/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing.menu;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.DevOptions;
import frc.emul.psg.dev.PsgRecording;
import frc.emul.util.Utils;
import frc.emul.util.swing.AARadioButtonMenuItem;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.swing.menu.UIGamePortMenu;
import frc.util.OSXAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIMenu {
    private final Configuration conf;
    private final UI emulUI;
    private final boolean standalone;
    private final UIGamePortMenu[] portMenus;
    private JMenuBar menuBar;
    public JCheckBoxMenuItem miTogglePause;
    public JMenuItem miSave;
    public JMenuItem miLoad;
    public JMenuItem miQSave;
    public JMenuItem miQLoad;
    public JMenuItem miReset;
    public JMenuItem miSnap;
    public JMenuItem miExit;
    public JMenuItem miToggleMenu;
    public JMenuItem miOptimizeSize;
    public JMenuItem miShaderSettings;
    public JMenuItem miShaderProfile;
    public JCheckBoxMenuItem miToggleAA;
    public JCheckBoxMenuItem miToggleChassis;
    public JCheckBoxMenuItem miToggleOverlay;
    public JCheckBoxMenuItem miTogglePersistence;
    public JCheckBoxMenuItem miToggleShader;
    public JCheckBoxMenuItem miToggleSound;
    public JMenuItem miSetFPS;
    public JCheckBoxMenuItem miToggleFPS;
    public JMenuItem miKeymapping;
    public JMenuItem miAnalog;
    public JMenuItem miReloadRom;
    public static final String HIDE_MENU_TITLE = "Hide Menu";
    private static final String[] SAMPFREQ_LABELS = new String[]{"44,100 Hz", "33,075 Hz", "22,050 Hz", "11,025 Hz"};
    private static final int[] SAMPFREQ_VALUES = new int[]{44100, 33075, 22050, 11025};

    public UIMenu(UI uI, boolean bl, Configuration configuration) {
        this.standalone = bl;
        this.emulUI = uI;
        this.conf = configuration;
        this.portMenus = new UIGamePortMenu[2];
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getFileMenu());
            this.menuBar.add(this.getDisplayMenu());
            this.menuBar.add(this.getSoundMenu());
            this.menuBar.add(this.getControlsMenu());
            this.menuBar.add(this.getDebugMenu());
            if (this.standalone) {
                this.menuBar.add(this.getHelpMenu());
            }
            if (Utils.isMacOSX()) {
                this.setupMacOSX();
            }
        }
        return this.menuBar;
    }

    public void initialiseListeners(Vectrex vectrex) {
        int n = 0;
        while (n < 2) {
            this.portMenus[n].initialiseContent(vectrex);
            ++n;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                UIMenu.this.handlePropertyChanges(propertyChangeEvent);
            }
        };
        this.getEmulUI().getDisplayContext().addPropertyChangeListener(propertyChangeListener);
        propertyChangeListener.propertyChange(null);
    }

    public void keyMappingChanged() {
        if (this.menuBar == null) {
            return;
        }
        CfgItemKeymapping cfgItemKeymapping = this.conf.keyMapping;
        this.miExit.setAccelerator(cfgItemKeymapping.keyExit.getKeyStroke());
        this.miLoad.setAccelerator(cfgItemKeymapping.keyLoad.getKeyStroke());
        this.miOptimizeSize.setAccelerator(cfgItemKeymapping.keySizeOptim.getKeyStroke());
        this.miQLoad.setAccelerator(cfgItemKeymapping.keyQuickLoad.getKeyStroke());
        this.miQSave.setAccelerator(cfgItemKeymapping.keyQuickSave.getKeyStroke());
        this.miSave.setAccelerator(cfgItemKeymapping.keySave.getKeyStroke());
        this.miToggleMenu.setAccelerator(cfgItemKeymapping.keyMenu.getKeyStroke());
    }

    private void setupMacOSX() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ParaJVE");
        if (!this.conf.options.display_fullscreen) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        new MacOSXHandler().install();
    }

    private JMenu getFileMenu() {
        JMenu jMenu = new JMenu("File");
        this.miSave = new JMenuItem("Save...");
        this.miLoad = new JMenuItem("Load...");
        this.miQSave = new JMenuItem("Quick Save");
        this.miQLoad = new JMenuItem("Quick Load");
        this.miSnap = new JMenuItem("Take ScreenShot...");
        this.miExit = new JMenuItem("Exit");
        CfgItemKeymapping cfgItemKeymapping = this.conf.keyMapping;
        this.miSave.setAccelerator(cfgItemKeymapping.keySave.getKeyStroke());
        this.miLoad.setAccelerator(cfgItemKeymapping.keyLoad.getKeyStroke());
        this.miQSave.setAccelerator(cfgItemKeymapping.keyQuickSave.getKeyStroke());
        this.miQLoad.setAccelerator(cfgItemKeymapping.keyQuickLoad.getKeyStroke());
        this.miExit.setAccelerator(cfgItemKeymapping.keyExit.getKeyStroke());
        jMenu.add(this.miSnap);
        jMenu.addSeparator();
        jMenu.add(this.miSave);
        jMenu.add(this.miLoad);
        jMenu.addSeparator();
        jMenu.add(this.miQSave);
        jMenu.add(this.miQLoad);
        if (this.standalone) {
            jMenu.addSeparator();
            jMenu.add(this.miExit);
        }
        this.miSnap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.snapshot();
            }
        });
        this.miSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.save();
            }
        });
        this.miLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.load();
            }
        });
        this.miQSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.quickSave();
            }
        });
        this.miQLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.quickLoad();
            }
        });
        this.miExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.execQuit();
            }
        });
        return jMenu;
    }

    private JMenu getControlsMenu() {
        JMenu jMenu = new JMenu("Controls");
        this.miTogglePause = new JCheckBoxMenuItem("Pause", this.emulUI.isPaused());
        this.miKeymapping = new JMenuItem("Key Mapping...");
        this.miAnalog = new JMenuItem("Mouse Settings...");
        this.miReset = new JMenuItem("Reset");
        jMenu.add(this.miKeymapping);
        jMenu.add(this.miAnalog);
        jMenu.addSeparator();
        int n = 0;
        while (n < 2) {
            this.portMenus[n] = new UIGamePortMenu(this, n);
            jMenu.add(this.portMenus[n].getMenu());
            ++n;
        }
        jMenu.addSeparator();
        jMenu.add(this.miTogglePause);
        jMenu.add(this.miReset);
        this.miTogglePause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.setPaused(!UIMenu.this.emulUI.isPaused());
            }
        });
        this.miReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.reset();
            }
        });
        this.miKeymapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.execKeysPrefs();
            }
        });
        this.miAnalog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.editAnalogSettings();
            }
        });
        return jMenu;
    }

    private JMenu getDisplayMenu() {
        boolean bl = !this.getConf().options.display_fullscreen;
        JMenu jMenu = new JMenu("Display");
        final JMenuItem jMenuItem = new JMenuItem("Chassis settings...");
        JMenuItem jMenuItem2 = new JMenuItem("Vectors settings...");
        final JMenu jMenu2 = new JMenu("Overlay Rendering");
        JMenu jMenu3 = new JMenu("Rotate Display");
        JMenu jMenu4 = new JMenu("Glow settings");
        this.miToggleChassis = new JCheckBoxMenuItem("Draw Chassis", this.emulUI.isChassisEnabled());
        this.miToggleOverlay = new JCheckBoxMenuItem("Draw Overlay", this.emulUI.isOverlayEnabled());
        this.miToggleAA = new JCheckBoxMenuItem("Anti-Aliasing", this.emulUI.isAntiAliasEnabled());
        this.miTogglePersistence = new JCheckBoxMenuItem("Vectors Persistence", this.emulUI.isPersistenceEnabled());
        this.miToggleShader = new JCheckBoxMenuItem("Vectors Glow", this.emulUI.isGlowShaderEnabled());
        this.miToggleMenu = new JMenuItem(HIDE_MENU_TITLE);
        this.miOptimizeSize = new JMenuItem("Optimize Size");
        this.miShaderSettings = new JMenuItem("Edit Settings...");
        this.miShaderProfile = new JMenuItem("Select Profile...");
        CfgItemKeymapping cfgItemKeymapping = this.conf.keyMapping;
        this.miOptimizeSize.setAccelerator(cfgItemKeymapping.keySizeOptim.getKeyStroke());
        this.miToggleMenu.setAccelerator(cfgItemKeymapping.keyMenu.getKeyStroke());
        this.miTogglePersistence.setEnabled(this.emulUI.isPersistenceAllowed());
        this.miOptimizeSize.setEnabled(bl);
        this.fillDisplayRotationMenu(jMenu3);
        this.fillOverlayModeMenu(jMenu2);
        jMenu4.add(this.miShaderSettings);
        jMenu4.add(this.miShaderProfile);
        jMenu.add(this.miToggleMenu);
        if (bl) {
            jMenu.add(this.miOptimizeSize);
        }
        jMenu.addSeparator();
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        jMenu.add(jMenu2);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(this.miToggleShader);
        jMenu.add(this.miToggleOverlay);
        jMenu.add(this.miToggleChassis);
        jMenu.add(this.miTogglePersistence);
        jMenu.add(this.miToggleAA);
        this.miOptimizeSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.optimizeWindowSize();
            }
        });
        this.miToggleMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleMenu();
            }
        });
        this.miToggleAA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleAntiAlias();
            }
        });
        this.miTogglePersistence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.togglePersistence();
            }
        });
        this.miToggleShader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleGlowShader();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.editMiscDisplaySettings();
            }
        });
        this.miShaderSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.editGlowShaderSettings();
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.editChassisSettings();
            }
        });
        this.miShaderProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.selectShaderProfile();
            }
        });
        this.miToggleChassis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleChassis();
                jMenuItem.setEnabled(UIMenu.this.emulUI.isChassisEnabled());
            }
        });
        this.miToggleOverlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleOverlay();
                jMenu2.setEnabled(UIMenu.this.emulUI.isOverlayEnabled());
            }
        });
        jMenu2.setEnabled(this.miToggleOverlay.isSelected());
        jMenuItem.setEnabled(this.miToggleChassis.isSelected());
        return jMenu;
    }

    private JMenu getSoundMenu() {
        JMenu jMenu = new JMenu("Sound");
        this.miToggleSound = new JCheckBoxMenuItem("Enable Sound", this.emulUI.isSoundEnabled());
        JMenu jMenu2 = new JMenu("Master Volume");
        JMenu jMenu3 = new JMenu("Sample Rate");
        jMenu.add(this.miToggleSound);
        jMenu.addSeparator();
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        this.fillMasterVolumeMenu(jMenu2);
        this.fillSampleRateMenu(jMenu3);
        this.miToggleSound.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleSound();
            }
        });
        return jMenu;
    }

    private JMenu getDebugMenu() {
        JMenu jMenu = new JMenu("Debug");
        this.miToggleFPS = new JCheckBoxMenuItem("Show FPS", this.emulUI.isFpsDrawn());
        this.miSetFPS = new JMenuItem("Set FrameRate...");
        jMenu.add(this.miSetFPS);
        jMenu.add(this.miToggleFPS);
        this.populateDebugMenu(jMenu, this.conf.options.debugMode, DevOptions.showDevMenuItems);
        this.miSetFPS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.selectFPS();
            }
        });
        this.miToggleFPS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleFps();
            }
        });
        return jMenu;
    }

    private JMenu getHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Check for new versions...");
        JMenuItem jMenuItem2 = new JMenuItem("Browse ParaJVE Blog...");
        JMenuItem jMenuItem3 = new JMenuItem("Open the Game Documentation...");
        JMenuItem jMenuItem4 = new JMenuItem("Open the Release Notes...");
        JMenuItem jMenuItem5 = new JMenuItem("Open the User Guide...");
        JMenuItem jMenuItem6 = new JMenuItem("Welcome...");
        JMenuItem jMenuItem7 = new JMenuItem("About ParaJVE...");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem6);
        jMenu.add(jMenuItem7);
        jMenuItem3.setEnabled(this.conf.getSelectedGame().isDocAvailable());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.checkNewVersion();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.browseBlog();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.browseGameDoc();
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.browseUserGuide();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.browseReleaseNotes();
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.execWelcome();
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.execAbout();
            }
        });
        return jMenu;
    }

    private JCheckBoxMenuItem buildMuteMenuItem(String string, final int n) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.toggleSoundChannelMuted(n);
            }
        });
        return jCheckBoxMenuItem;
    }

    private void fillDisplayRotationMenu(JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < 360) {
            AARadioButtonMenuItem aARadioButtonMenuItem = new AARadioButtonMenuItem(Integer.toString(n));
            buttonGroup.add(aARadioButtonMenuItem);
            jMenu.add(aARadioButtonMenuItem);
            aARadioButtonMenuItem.setSelected(this.emulUI.getDisplayRotation() == n);
            final int n2 = n;
            aARadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.setDisplayRotation(n2);
                }
            });
            n += 90;
        }
    }

    private void fillOverlayModeMenu(JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = this.emulUI.getDisplayContext().getOverlayModeLabels();
        int n = this.emulUI.getOverlayMode();
        int n2 = 0;
        while (n2 < stringArray.length) {
            final int n3 = n2 + 1;
            AARadioButtonMenuItem aARadioButtonMenuItem = new AARadioButtonMenuItem(stringArray[n2]);
            buttonGroup.add(aARadioButtonMenuItem);
            jMenu.add(aARadioButtonMenuItem);
            aARadioButtonMenuItem.setSelected(n == n3);
            aARadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.setOverlayMode(n3);
                }
            });
            ++n2;
        }
    }

    private void fillMasterVolumeMenu(JMenu jMenu) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n = 20;
        while (n <= 100) {
            ((Dictionary)hashtable).put(n, new JLabel(" " + n + "%"));
            n += 20;
        }
        ((Dictionary)hashtable).put(0, new JLabel(" Off  "));
        n = Math.min(100, Math.max(0, (int)(100.0f * this.conf.options.snd_volume)));
        final JSlider jSlider = new JSlider(1, 0, 100, n);
        jSlider.setMajorTickSpacing(100);
        jSlider.setMinorTickSpacing(10);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setOpaque(false);
        jSlider.setLabelTable(hashtable);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                UIMenu.this.emulUI.setSoundVolume((float)jSlider.getValue() / 100.0f);
            }
        });
        jMenu.add(jSlider);
    }

    private void fillSampleRateMenu(JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        final int n = this.conf.options.snd_samplingFreq;
        int n2 = 0;
        while (n2 < SAMPFREQ_LABELS.length) {
            final int n3 = SAMPFREQ_VALUES[n2];
            AARadioButtonMenuItem aARadioButtonMenuItem = new AARadioButtonMenuItem(SAMPFREQ_LABELS[n2]);
            buttonGroup.add(aARadioButtonMenuItem);
            jMenu.add(aARadioButtonMenuItem);
            aARadioButtonMenuItem.setSelected(n3 == n);
            aARadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.setSoundSamplingFreq(n3);
                }
            });
            ++n2;
        }
        if (buttonGroup.getSelection() == null) {
            jMenu.addSeparator();
            AARadioButtonMenuItem aARadioButtonMenuItem = new AARadioButtonMenuItem(String.valueOf(Integer.toString(n)) + " Hz (User Defined)", true);
            buttonGroup.add(aARadioButtonMenuItem);
            jMenu.add(aARadioButtonMenuItem);
            aARadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.setSoundSamplingFreq(n);
                }
            });
        }
    }

    private void populateDebugMenu(JMenu jMenu, boolean bl, boolean bl2) {
        this.miReloadRom = new JMenuItem(this.conf.getSelectedGame().cartridge.built ? "Rebuild Cartridge ROM" : "Reload Cartridge ROM");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Enable Back-tracing", false);
        JMenuItem jMenuItem = new JMenuItem("Open Audio Monitor...");
        JMenu jMenu2 = new JMenu("Mute Audio Channels");
        JCheckBoxMenuItem jCheckBoxMenuItem2 = null;
        JMenuItem jMenuItem2 = null;
        JMenuItem jMenuItem3 = null;
        JMenuItem jMenuItem4 = new JMenuItem("Inject RAM in Cartridge...");
        JCheckBoxMenuItem jCheckBoxMenuItem3 = null;
        boolean bl3 = this.conf.getSelectedGame().hasCartridge();
        jMenu.addSeparator();
        if (bl2) {
            jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Reference Grids", this.emulUI.isDebugRefGridDrawn());
            jMenuItem2 = new JMenuItem("Select another Cartridge...");
            jMenuItem3 = new JMenuItem("Rendering Tweaking...");
            jMenu.add(jCheckBoxMenuItem2);
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
        }
        if (bl) {
            jMenu.add(jMenu2);
            jMenu.add(jMenuItem);
            jMenu2.add(this.buildMuteMenuItem("Channel A", 0));
            jMenu2.add(this.buildMuteMenuItem("Channel B", 1));
            jMenu2.add(this.buildMuteMenuItem("Channel C", 2));
        }
        if (bl2) {
            jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Record PSG input", PsgRecording.INSTANCE.isRecording());
            jMenu.add(jCheckBoxMenuItem3);
        }
        if (bl) {
            jMenu.addSeparator();
            jMenu.add(jCheckBoxMenuItem);
        }
        jMenu.add(this.miReloadRom);
        if (bl2) {
            jMenu.add(jMenuItem2);
        }
        jMenu.add(jMenuItem4);
        this.miReloadRom.setEnabled(bl3);
        this.miReloadRom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.reloadRoms();
            }
        });
        jMenuItem4.setEnabled(bl3);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.injectRamInCartridge();
            }
        });
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vectrex vectrex;
                vectrex.setRecordingTrace(!(vectrex = Vectrex.INSTANCE).isRecordingTrace());
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIMenu.this.emulUI.openAudioMonitor();
            }
        });
        if (jMenuItem2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.switchGame();
                }
            });
        }
        if (jCheckBoxMenuItem2 != null) {
            jCheckBoxMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.toggleDebugRefGrid();
                }
            });
        }
        if (jMenuItem3 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIMenu.this.emulUI.openGfxItemLimiter();
                }
            });
        }
        if (jCheckBoxMenuItem3 != null) {
            jCheckBoxMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PsgRecording psgRecording;
                    psgRecording.setRecording(!(psgRecording = PsgRecording.INSTANCE).isRecording());
                }
            });
        }
    }

    void handlePropertyChanges(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            this.shaderPropertyChanged();
        } else if ("SHADER_BLOCKED".equals(propertyChangeEvent.getPropertyName())) {
            this.shaderPropertyChanged();
        }
    }

    private void shaderPropertyChanged() {
        if (this.getEmulUI().isGlowShaderBlocked()) {
            this.miToggleShader.setEnabled(false);
            this.miToggleShader.setSelected(false);
            this.conf.options.glowShader.active = false;
            this.conf.setDirty(true);
            UIMenu.invokeAndWaitEDT(new Runnable(){

                public void run() {
                    UIMenu.this.displayAndWaitEDT("ParaJVE", "The Vector's Glow Shader cannot run on this computer. \nAs a consequence, it will been automatically disabled. \n ", 2);
                }
            });
        }
    }

    private void displayAndWaitEDT(final String string, final String string2, final int n) {
        UIMenu.invokeAndWaitEDT(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(UIMenu.this.emulUI.getWindow(), string2, string, n);
            }
        });
    }

    private static void invokeAndWaitEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                throw new RuntimeException("Exception while invoking action in EDT", exception);
            }
        }
    }

    private void execKeysPrefs() {
        this.emulUI.editKeyMapping();
    }

    private void execWelcome() {
        this.emulUI.welcome();
    }

    private void execAbout() {
        this.emulUI.about();
    }

    private void execQuit() {
        this.emulUI.exit();
    }

    final Configuration getConf() {
        return this.conf;
    }

    final boolean isStandalone() {
        return this.standalone;
    }

    final UI getEmulUI() {
        return this.emulUI;
    }

    public final class MacOSXHandler {
        private void install() {
            try {
                OSXAdapter.setPreferencesHandler(this, this.fetchMethod("handlePrefs"));
                OSXAdapter.setAboutHandler(this, this.fetchMethod("handleAbout"));
                OSXAdapter.setQuitHandler(this, this.fetchMethod("handleQuit"));
            }
            catch (Throwable throwable) {
                System.err.println("*** Error while installing the OSXAdapter:");
                throwable.printStackTrace(System.err);
            }
        }

        private Method fetchMethod(String string) throws Exception {
            return this.getClass().getDeclaredMethod(string, null);
        }

        public void handlePrefs() {
            UIMenu.this.execKeysPrefs();
        }

        public void handleAbout() {
            UIMenu.this.execAbout();
        }

        public void handleQuit() {
            UIMenu.this.execQuit();
        }
    }
}

